% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_slogdet}
\alias{torch_slogdet}
\title{Slogdet}
\usage{
torch_slogdet(self)
}
\arguments{
\item{self}{(Tensor) the input tensor of size \verb{(*, n, n)} where \code{*} is zero or more                batch dimensions.}
}
\description{
Slogdet
}
\note{
\preformatted{If `input` has zero determinant, this returns `(0, -inf)`.
}

\preformatted{Backward through `slogdet` internally uses SVD results when `input`
is not invertible. In this case, double backward through `slogdet`
will be unstable in when `input` doesn't have distinct singular values.
See `~torch.svd` for details.
}
}
\section{slogdet(input) -> (Tensor, Tensor) }{


Calculates the sign and log absolute value of the determinant(s) of a square matrix or batches of square matrices.
}

\examples{
if (torch_is_installed()) {

A = torch_randn(c(3, 3))
A
torch_det(A)
torch_logdet(A)
torch_slogdet(A)
}
}
