% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_solve}
\alias{torch_solve}
\title{Solve}
\usage{
torch_solve(self, A)
}
\arguments{
\item{self}{(Tensor) input matrix \eqn{B} of size \eqn{(*, m, k)} , where \eqn{*}                is zero or more batch dimensions.}

\item{A}{(Tensor) input square matrix of size \eqn{(*, m, m)}, where                \eqn{*} is zero or more batch dimensions.}
}
\description{
Solve
}
\note{
\preformatted{Irrespective of the original strides, the returned matrices
`solution` and `LU` will be transposed, i.e. with strides like
`B$contiguous()$transpose(-1, -2)$stride()` and
`A$contiguous()$transpose(-1, -2)$stride()` respectively.
}
}
\section{solve(input, A) -> (Tensor, Tensor) }{


This function returns the solution to the system of linear
equations represented by \eqn{AX = B} and the LU factorization of
A, in order as a namedtuple \verb{solution, LU}.

\code{LU} contains \code{L} and \code{U} factors for LU factorization of \code{A}.

\code{torch_solve(B, A)} can take in 2D inputs \verb{B, A} or inputs that are
batches of 2D matrices. If the inputs are batches, then returns
batched outputs \verb{solution, LU}.
}

\examples{
if (torch_is_installed()) {

A = torch_tensor(rbind(c(6.80, -2.11,  5.66,  5.97,  8.23),
                      c(-6.05, -3.30,  5.36, -4.44,  1.08),
                      c(-0.45,  2.58, -2.70,  0.27,  9.04),
                      c(8.32,  2.71,  4.35,  -7.17,  2.14),
                      c(-9.67, -5.14, -7.26,  6.08, -6.87)))$t()
B = torch_tensor(rbind(c(4.02,  6.19, -8.22, -7.57, -3.03),
                      c(-1.56,  4.00, -8.67,  1.75,  2.86),
                      c(9.81, -4.09, -4.57, -8.61,  8.99)))$t()
out = torch_solve(B, A)
X = out[[1]]
LU = out[[2]]
torch_dist(B, torch_mm(A, X))
# Batched solver example
A = torch_randn(c(2, 3, 1, 4, 4))
B = torch_randn(c(2, 3, 1, 4, 6))
out = torch_solve(B, A)
X = out[[1]]
LU = out[[2]]
torch_dist(B, A$matmul(X))
}
}
