% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-loss.R
\name{nn_margin_ranking_loss}
\alias{nn_margin_ranking_loss}
\title{Margin ranking loss}
\usage{
nn_margin_ranking_loss(margin = 0, reduction = "mean")
}
\arguments{
\item{margin}{(float, optional): Has a default value of \eqn{0}.}

\item{reduction}{(string, optional): Specifies the reduction to apply to the output:
\code{'none'} | \code{'mean'} | \code{'sum'}. \code{'none'}: no reduction will be applied,
\code{'mean'}: the sum of the output will be divided by the number of
elements in the output, \code{'sum'}: the output will be summed. Note: \code{size_average}
and \code{reduce} are in the process of being deprecated, and in the meantime,
specifying either of those two args will override \code{reduction}. Default: \code{'mean'}}
}
\description{
Creates a criterion that measures the loss given
inputs \eqn{x1}, \eqn{x2}, two 1D mini-batch \code{Tensors},
and a label 1D mini-batch tensor \eqn{y} (containing 1 or -1).
If \eqn{y = 1} then it assumed the first input should be ranked higher
(have a larger value) than the second input, and vice-versa for \eqn{y = -1}.
}
\details{
The loss function for each pair of samples in the mini-batch is:

\deqn{
  \mbox{loss}(x1, x2, y) = \max(0, -y * (x1 - x2) + \mbox{margin})
}
}
\section{Shape}{

\itemize{
\item Input1: \eqn{(N)} where \code{N} is the batch size.
\item Input2: \eqn{(N)}, same shape as the Input1.
\item Target: \eqn{(N)}, same shape as the inputs.
\item Output: scalar. If \code{reduction} is \code{'none'}, then \eqn{(N)}.
}
}

\examples{
if (torch_is_installed()) {
loss <- nn_margin_ranking_loss()
input1 <- torch_randn(3, requires_grad = TRUE)
input2 <- torch_randn(3, requires_grad = TRUE)
target <- torch_randn(3)$sign()
output <- loss(input1, input2, target)
output$backward()
}
}
