% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_cat}
\alias{torch_cat}
\title{Cat}
\usage{
torch_cat(tensors, dim = 1L)
}
\arguments{
\item{tensors}{(sequence of Tensors) any python sequence of tensors of the same type.        Non-empty tensors provided must have the same shape, except in the        cat dimension.}

\item{dim}{(int, optional) the dimension over which the tensors are concatenated}
}
\description{
Cat
}
\section{cat(tensors, dim=0, out=NULL) -> Tensor }{


Concatenates the given sequence of \code{seq} tensors in the given dimension.
All tensors must either have the same shape (except in the concatenating
dimension) or be empty.

\code{\link{torch_cat}} can be seen as an inverse operation for \code{\link[=torch_split]{torch_split()}}
and \code{\link{torch_chunk}}.

\code{\link{torch_cat}} can be best understood via examples.
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(2, 3))
x
torch_cat(list(x, x, x), 1)
torch_cat(list(x, x, x), 2)
}
}
