% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn-sparse.R
\name{nn_embedding}
\alias{nn_embedding}
\title{Embedding module}
\usage{
nn_embedding(
  num_embeddings,
  embedding_dim,
  padding_idx = NULL,
  max_norm = NULL,
  norm_type = 2,
  scale_grad_by_freq = FALSE,
  sparse = FALSE,
  .weight = NULL
)
}
\arguments{
\item{num_embeddings}{(int): size of the dictionary of embeddings}

\item{embedding_dim}{(int): the size of each embedding vector}

\item{padding_idx}{(int, optional): If given, pads the output with the embedding vector at \code{padding_idx}
(initialized to zeros) whenever it encounters the index.}

\item{max_norm}{(float, optional): If given, each embedding vector with norm larger than \code{max_norm}
is renormalized to have norm \code{max_norm}.}

\item{norm_type}{(float, optional): The p of the p-norm to compute for the \code{max_norm} option. Default \code{2}.}

\item{scale_grad_by_freq}{(boolean, optional): If given, this will scale gradients by the inverse of frequency of
the words in the mini-batch. Default \code{False}.}

\item{sparse}{(bool, optional): If \code{True}, gradient w.r.t. \code{weight} matrix will be a sparse tensor.}

\item{.weight}{(Tensor) embeddings weights (in case you want to set it manually)

See Notes for more details regarding sparse gradients.}
}
\description{
A simple lookup table that stores embeddings of a fixed dictionary and size.
This module is often used to store word embeddings and retrieve them using indices.
The input to the module is a list of indices, and the output is the corresponding
word embeddings.
}
\note{
Keep in mind that only a limited number of optimizers support
sparse gradients: currently it's \code{optim.SGD} (\code{CUDA} and \code{CPU}),
\code{optim.SparseAdam} (\code{CUDA} and \code{CPU}) and \code{optim.Adagrad} (\code{CPU})

With \code{padding_idx} set, the embedding vector at
\code{padding_idx} is initialized to all zeros. However, note that this
vector can be modified afterwards, e.g., using a customized
initialization method, and thus changing the vector used to pad the
output. The gradient for this vector from \link{nn_embedding}
is always zero.
}
\section{Attributes}{

\itemize{
\item weight (Tensor): the learnable weights of the module of shape (num_embeddings, embedding_dim)
initialized from \eqn{\mathcal{N}(0, 1)}
}
}

\section{Shape}{

\itemize{
\item Input: \eqn{(*)}, LongTensor of arbitrary shape containing the indices to extract
\item Output: \eqn{(*, H)}, where \code{*} is the input shape and \eqn{H=\mbox{embedding\_dim}}
}
}

\examples{
if (torch_is_installed()) {
# an Embedding module containing 10 tensors of size 3
embedding <- nn_embedding(10, 3)
# a batch of 2 samples of 4 indices each
input <- torch_tensor(rbind(c(1, 2, 4, 5), c(4, 3, 2, 9)), dtype = torch_long())
embedding(input)
# example with padding_idx
embedding <- nn_embedding(10, 3, padding_idx = 1)
input <- torch_tensor(matrix(c(1, 3, 1, 6), nrow = 1), dtype = torch_long())
embedding(input)
}
}
