% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_complex}
\alias{torch_complex}
\title{Complex}
\usage{
torch_complex(real, imag)
}
\arguments{
\item{real}{(Tensor) The real part of the complex tensor. Must be float or double.}

\item{imag}{(Tensor) The imaginary part of the complex tensor. Must be same dtype
as \code{real}.}
}
\description{
Complex
}
\section{complex(real, imag, *, out=None) -> Tensor }{


Constructs a complex tensor with its real part equal to \code{real} and its
imaginary part equal to \code{imag}.
}

\examples{
if (torch_is_installed()) {

real <- torch_tensor(c(1, 2), dtype=torch_float32())
imag <- torch_tensor(c(3, 4), dtype=torch_float32())
z <- torch_complex(real, imag)
z
z$dtype
}
}
