% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_mode}
\alias{torch_mode}
\title{Mode}
\usage{
torch_mode(self, dim = -1L, keepdim = FALSE)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{dim}{(int) the dimension to reduce.}

\item{keepdim}{(bool) whether the output tensor has \code{dim} retained or not.}
}
\description{
Mode
}
\note{
This function is not defined for \code{torch_cuda.Tensor} yet.
}
\section{mode(input, dim=-1, keepdim=False, out=NULL) -> (Tensor, LongTensor) }{


Returns a namedtuple \verb{(values, indices)} where \code{values} is the mode
value of each row of the \code{input} tensor in the given dimension
\code{dim}, i.e. a value which appears most often
in that row, and \code{indices} is the index location of each mode value found.

By default, \code{dim} is the last dimension of the \code{input} tensor.

If \code{keepdim} is \code{TRUE}, the output tensors are of the same size as
\code{input} except in the dimension \code{dim} where they are of size 1.
Otherwise, \code{dim} is squeezed (see \code{\link{torch_squeeze}}), resulting
in the output tensors having 1 fewer dimension than \code{input}.
}

\examples{
if (torch_is_installed()) {

a = torch_randint(0, 50, size = list(5))
a
torch_mode(a, 1)
}
}
