% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess-the-correlation.R
\name{guess_the_correlation_dataset}
\alias{guess_the_correlation_dataset}
\title{Guess The Correlation dataset}
\usage{
guess_the_correlation_dataset(
  root,
  split = "train",
  transform = NULL,
  indexes = NULL,
  download = FALSE
)
}
\arguments{
\item{root}{path to the data location}

\item{split}{string. 'train' or 'submission'}

\item{transform}{function that receives a torch tensor and return another torch tensor, transformed.}

\item{indexes}{set of integers for subsampling (e.g. 1:140000)}

\item{download}{whether to download or not}
}
\value{
A torch dataset that can be consumed with \code{\link[torch:dataloader]{torch::dataloader()}}.
}
\description{
Prepares the Guess The Correlation dataset available on Kaggle \href{https://www.kaggle.com/c/guess-the-correlation}{here}
A copy of this dataset is hosted in a public Google Cloud
bucket so you don't need to authenticate.
}
\examples{
if (torch::torch_is_installed() && FALSE) {
gtc <- guess_the_correlation_dataset("./data", download = TRUE)
length(gtc)
}
}
