% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.textmeta.corpus.R
\name{as.textmeta.corpus}
\alias{as.textmeta.corpus}
\title{Transform corpus to textmeta}
\usage{
as.textmeta.corpus(corpus, cols, dateFormat = "\%Y-\%m-\%d",
  idCol = "id", dateCol = "date", titleCol = "title",
  textCol = "texts", duplicateAction = TRUE, addMetadata = TRUE)
}
\arguments{
\item{corpus}{Object of class \code{\link[quanteda]{corpus}},
package \code{\link[quanteda]{quanteda}}.}

\item{cols}{Character: vector with columns which should be kept.}

\item{dateFormat}{Character: string with the date format in the
date column for \code{\link{as.Date}}.}

\item{idCol}{Character: string with column name of the IDs in corpus
- named "id" in the resulting data.frame.}

\item{dateCol}{Character: string with column name of the Dates in corpus
- named "date" in the resulting data.frame.}

\item{titleCol}{Character: string with column name of the Titles in corpus
- named "title" in the resulting data.frame.}

\item{textCol}{Character: string with column name of the Texts in corpus
- results in a named list ("id") of the Texts.}

\item{duplicateAction}{Logical:
Should \code{\link{deleteAndRenameDuplicates}} be applied to the
created \code{\link{textmeta}} object?}

\item{addMetadata}{Logical: Should the metadata flag of corpus
be added to the meta flag of the \code{\link{textmeta}} object? If there are
conflicts regarding the naming of columns, the metadata columns would be
overwritten by the document specific columns.}
}
\value{
\code{\link{textmeta}} object
}
\description{
Transfers data from a \code{\link[quanteda]{corpus}} object -  the way text
data is stored in the package \code{\link[quanteda]{quanteda}} - to a
\code{\link{textmeta}} object.
}
\examples{
texts <- c("Give a Man a Fish, and You Feed Him for a Day.
 Teach a Man To Fish, and You Feed Him for a Lifetime",
 "So Long, and Thanks for All the Fish",
 "A very able manipulative mathematician, Fisher enjoys a real mastery
 in evaluating complicated multiple integrals.")

corp <- quanteda::corpus(x = texts)
obj <- as.textmeta.corpus(corp, addMetadata = FALSE)

quanteda::docvars(corp, "title") <- c("Fishing", "Don't panic!", "Sir Ronald")
quanteda::docvars(corp, "date") <- c("1885-01-02", "1979-03-04", "1951-05-06")
quanteda::docvars(corp, "id") <- c("A", "B", "C")
quanteda::docvars(corp, "additionalVariable") <- 1:3

obj <- as.textmeta.corpus(corp)
}
\keyword{manip}
