% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{config_file}
\alias{config_file}
\title{Get Normalized Configuration File Path of a Program}
\usage{
config_file(
  app_name,
  file_name,
  cl_arg = {
     commandArgs()[grep("--config-file", commandArgs()) + 1]
 },
  env_var = "",
  sep = "/",
  copy_dir = norm_path(xdg_config_home(), app_name),
  fallback_path = NULL
)
}
\arguments{
\item{app_name}{Name of the program/package/app}

\item{file_name}{Name of the configuration file}

\item{cl_arg}{Value of app specific commandline parameter}

\item{env_var}{Value of app specific environment variable}

\item{sep}{Path separator to be used on Windows}

\item{copy_dir}{Path to directory where \verb{$fallback_path} should be copied to
in case it gets used.}

\item{fallback_path}{Value to return as fallback (see details)}
}
\value{
Normalized path to the configuration file of \verb{$app_name}.
}
\description{
\code{config_file} returns the absolute, normalized path to the
configuration file of a program/package/app based on an optional
app-specific commandline argument, an optional app-specific environment
variable and the \href{https://specifications.freedesktop.org/basedir-spec/basedir-spec-latest.html}{XDG Base Directory Specification}
}
\details{
The following algorithm is used to determine the location of
\verb{$file_name}:
\enumerate{
\item If \verb{$cl_arg} is a non-empty string, return it
\item Else, if \verb{$env_var} is a non-empty string, return it
\item Else, if \verb{$PWD/.config/$app_name} exists, return it
\item Else, if \verb{$XDG_CONFIG_HOME/$app_name/$file_name} exists, return it
\item Else, if \verb{$HOME/.config/$app_name/$file_name} exists, return it
\item Else, if \verb{$USERPROFILE/.config/$app_name/$file_name} exists, return it
\item Else, if \verb{$copy_dir} is non-empty string and \verb{$fallback_path} is a path
to an existing file, then try to copy \verb{$fallback_path} to
\code{copy_dir}/\verb{$file_name} and return \code{copy_dir}/\verb{$file_name} (Note, that
in case $copy_dir is a non-valid path, the function will throw an error.)
\item Else, return $fallback_path
}
}
\examples{
config_dir("myApp")
}
\seealso{
\code{\link[=config_dir]{config_dir()}}, \code{\link[=xdg_config_home]{xdg_config_home()}}
}
\keyword{path}
