% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tox_endpoints2.R
\name{plot_tox_endpoints2}
\alias{plot_tox_endpoints2}
\title{EndPoint boxplots with faceting option}
\usage{
plot_tox_endpoints2(
  cs,
  ...,
  category = "Chemical",
  filterBy = "All",
  manual_remove = NULL,
  hit_threshold = NA,
  mean_logic = FALSE,
  sum_logic = TRUE,
  font_size = NA,
  title = NA,
  x_label = NA,
  palette = NA,
  top_num = NA
)
}
\arguments{
\item{cs}{Data.frame from \code{\link[toxEval]{get_chemical_summary}}.}

\item{...}{Additional group_by arguments. This can be handy for creating facet graphs.}

\item{category}{Either "Biological", "Chemical Class", or "Chemical".}

\item{filterBy}{Character. Either "All" or one of the filtered categories.}

\item{manual_remove}{Vector of categories to remove.}

\item{hit_threshold}{Numeric threshold defining a "hit".}

\item{mean_logic}{Logical. \code{TRUE} displays the mean sample from each site,
\code{FALSE} displays the maximum sample from each site.}

\item{sum_logic}{logical. \code{TRUE} sums the EARs in a specified grouping,
\code{FALSE} does not. \code{FALSE} may be better for traditional benchmarks as
opposed to ToxCast benchmarks.}

\item{font_size}{Numeric to adjust the axis font size.}

\item{title}{Character title for plot.}

\item{x_label}{Character for x label. Default is NA which produces an automatic label.}

\item{palette}{Vector of color palette for fill. Can be a named vector
to specify specific color for specific categories.}

\item{top_num}{Integer number of endpoints to include in the graph. If NA, all
endpoints will be included.}
}
\description{
The \code{plot_tox_endpoints2} function creates a set of boxplots representing EAR
values for each endPoint based on the selected data. A subset of data is first
chosen by specifying a group in the \code{filterBy} argument. The
\code{filterBy} argument must match one of the unique options in the category.
For example, if the category is "Chemical Class", then the \code{filterBy} argument
must be one of the defined "Chemical Class" options such as "Herbicide".
}
\details{
The difference between this function and the
\code{\link[toxEval]{plot_tox_endpoints}} is that
the \dots arguments allow for customized faceting. To include this in
the original toxEval function, backward compatibility would be broken.
}
\examples{

\donttest{
path_to_tox <- system.file("extdata", package = "toxEval")
file_name <- "OWC_data_fromSup.xlsx"

full_path <- file.path(path_to_tox, file_name)

tox_list <- create_toxEval(full_path)
ACC <- get_ACC(tox_list$chem_info$CAS)
ACC <- remove_flags(ACC)

cleaned_ep <- clean_endPoint_info(end_point_info)
filtered_ep <- filter_groups(cleaned_ep)
cs <- get_chemical_summary(tox_list, ACC, filtered_ep)
cs$guide_side <- "A"

cs2 <- cs
cs2$guide_side <- "B"

cs_double <- rbind(cs, cs2)

plot_tox_endpoints2(cs_double, guide_side,
  top_num = 10
) +
  ggplot2::facet_grid(. ~ guide_side, scales = "free_x")
}
}
