% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tcpl_based.R
\name{plot_tcpl_minimal}
\alias{plot_tcpl_minimal}
\title{Plot dose-resonse curves with minimal text annotation
This funciton plots dose-response curve with minimal text annotation,
no x and y axis label, 0 borders. Useful when need to present several plots
together.}
\usage{
plot_tcpl_minimal(tcpl_models, rank_table = NULL, spid_chnm_table = NULL,
  notation = FALSE, cunit = "M")
}
\arguments{
\item{tcpl_models}{the list object created by 'fit_curve_tcpl' function}

\item{rank_table}{the data.frame output from 'rank_tcpl' function}

\item{spid_chnm_table}{the spid, chnm, casn info table}

\item{notation}{value can be TRUE or FALSE, determine whehter to show potency metrics on the plot}

\item{cunit}{the unit of concentration, on default is "M" (molar).}
}
\value{
list of ggplot2 objects, each corresponding to one spid.
}
\description{
Plot dose-resonse curves with minimal text annotation
This funciton plots dose-response curve with minimal text annotation,
no x and y axis label, 0 borders. Useful when need to present several plots
together.
}
\examples{
## produce plots without notations
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info =
list(prim_assay = "Primary", toxi_assay = "Cytotox"))
plots_minimal <- plot_tcpl_minimal(demo_md)

## start from raw data
# define assay
assay_info <- list(prim_assay = "Primary",toxi_assay = "Cytotox")
# data normalization
demo_mc_norm <- normalize_per_plate(demo_mc, nctrl = "DMSO")
# filter out two test chemicals
demo_mc_norm <- dplyr::filter(demo_mc_norm, spid \%in\% c("TP0001502B05", "TP0001502B01"))
# fit curve with default 20\% threshold
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info)
# calculate TAA and Med_diff only
demo_rank <- rank_tcpl(demo_md, med_taa = NULL, med_med_diff = NULL)
#produce plots with notations
demo_plots <- plot_tcpl_minimal(demo_md, demo_rank, notation = TRUE)

##produce plots with notations, with changed concentration unit displayed on the plot
demo_plots <- plot_tcpl_minimal(demo_md, demo_rank, notation = TRUE, cunit = "uM")




}
