% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tproc.est.R
\name{tproc.est}
\alias{tproc.est}
\title{Two-Way Partial AUC Estimation}
\usage{
tproc.est(response, predictor, threshold = c(1, 0), plot = TRUE,
  smooth = FALSE)
}
\arguments{
\item{response}{a factor, numeric or character vector of responses; 
typically encoded with 0 (negative) and 1 (positive). 
Only two classes can be used in a ROC curve. If its levels are not 0 and 1,
the first level will be defaultly regarded as negative.}

\item{predictor}{a numeric vector of the same length than response, containing the predicted value of each observation. An ordered factor is coerced to a numeric.}

\item{threshold}{a length-two numeric vector; the first element is FPR threshold, the second is TPR.}

\item{plot}{logic; plot the ROC curve?}

\item{smooth}{if \code{TRUE}, the ROC curve is passed to \code{\link[pROC]{smooth}} to be smoothed.}
}
\value{
Estimation of two-way partial AUC and plot of ROC curve.
}
\description{
Estimate the area of region under ROC curve under pre-specific FPR/TPR constraints (two-way partial AUC). See \href{http://arxiv.org/abs/1508.00298}{Yang et al., 2016} for details.
}
\details{
This function estimates two-way partial AUC given response, predictor and pre-specific FPR/TPR constraints. The plot of corresponding ROC curve with pre-specific FPR/TPR is generated.
}
\examples{

library('pROC')
data(aSAH)
tproc.est(aSAH$outcome, aSAH$s100b, threshold=c(0.8,0.2),plot=TRUE)


}
\author{
Hanfang Yang, Kun Lu, Xiang Lyu, Feifang Hu, Yichuan Zhao.
}
\seealso{
\code{\link[pROC]{roc}}, \code{\link[tpAUC]{podc.est}}, \code{\link[tpAUC]{proc.est}}
}

