% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggwater.R
\name{ggwater}
\alias{ggwater}
\title{Add watermarks to ggplots}
\usage{
ggwater(text = "Not validated", scale = 1, rot = 30, col = "grey", alpha = 0.5)
}
\arguments{
\item{text}{What should be written on the plot}

\item{scale}{the size}

\item{rot}{rotation of the mark. Don't remember the unit.}

\item{col}{the colour (a value, not an expression) of the
watermark. Default is grey.}

\item{alpha}{alpha value for the watermark. Default is 0.5.}
}
\value{
a layer with a watermark that can be added to a plot
}
\description{
Add watermarks to ggplots
}
\details{
This used to be based on
https://www.r-bloggers.com/adding-watermarks-to-plots/ That
solution stopped working, and this new solution is simpler and
based on ggplot2 alone.
}
\examples{
library(ggplot2)
ff <- qplot(1:10, 11:20) + ggwater()
}
\seealso{
Other Plotting: 
\code{\link{canvasSize}()},
\code{\link{ggstamp}()},
\code{\link{ggwrite}()}
}
\concept{Plotting}
