% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{allEqual}
\alias{allEqual}
\title{Test whether all elements of a vector are equal}
\usage{
allEqual(x, ignoreMissing = FALSE)
}
\arguments{
\item{x}{A vector of any mode, including a list.}

\item{ignoreMissing}{If \code{TRUE}, missing elements will be ignored.
Otherwise the presence of missing values will result in a return value of
\code{FALSE}.}
}
\value{
\code{TRUE} if all elements test (exactly) equal; \code{FALSE}
  otherwise.
}
\description{
This function is a wrapper around \code{all}, testing whether all elements
of the specified vector are equal to each other.
}
\examples{

allEqual(c(1,1,1))  # TRUE
allEqual(c(1,1,NA))  # FALSE
allEqual(c(1,1,NA), ignoreMissing=TRUE)  # TRUE

}
\author{
Jon Clayden
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18.
\url{http://www.jstatsoft.org/v44/i08/}.
}
\seealso{
\code{\link{equivalent}} for elementwise equivalence of two
  vectors.
}

