% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ncbi_byid.R
\name{ncbi_byid}
\alias{ncbi_byid}
\title{Retrieve gene sequences from NCBI by accession number.}
\usage{
ncbi_byid(ids, format = "fasta", verbose = TRUE)
}
\arguments{
\item{ids}{(character) GenBank ids to search for.}

\item{format}{(character) Return type, e.g., \code{"fasta"}}

\item{verbose}{(logical) If \code{TRUE} (default), informative messages printed.}
}
\value{
Data.frame of results.
}
\description{
Retrieve gene sequences from NCBI by accession number.
}
\details{
Removes predicted sequences so you don't have to remove them.
    Predicted sequences are those with accession numbers that have "XM_" or
		"XR_" prefixes. This function retrieves one sequences for each species,
  	picking the longest available for the given gene.
}
\examples{
\dontrun{
# A single gene
ncbi_byid(ids="360040093", format="fasta")

# Many genes (with different accession numbers)
ncbi_byid(ids=c("360040093","347448433"), format="fasta")
}
}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{ncbi_search}}, \code{\link[taxize]{ncbi_getbyname}}
}

