% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_native.R
\name{is_native}
\alias{is_native}
\title{Check if a species is native somewhere}
\usage{
is_native(sp, where, region = c("america", "europe"), ...)
}
\arguments{
\item{sp}{character; a vector of length one with a single scientific species
names in the form of \code{c("Genus species")}.}

\item{where}{character; a vector of length one with a single place. For America has to
match one of those: "Continental US", "Alaska", "Canada", "Caribbean Territories",
"Central Pacific Territories", "Hawaii", "Mexico". For Europe has to match one of
those: "Albania", "Austria", "Azores", "Belgium", "Islas_Baleares", "Britain",
"Bulgaria", "Corse", "Kriti", "Czechoslovakia", "Denmark", "Faroer", "Finland",
"France", "Germany", "Greece", "Ireland", "Switzerland", "Netherlands", "Spain",
"Hungary", "Iceland", "Italy", "Jugoslavia", "Portugal", "Norway", "Poland", "Romania",
"USSR", "Sardegna", "Svalbard", "Sicilia", "Sweden", "Turkey", "USSR_Northern_Division",
"USSR_Baltic_Division", "USSR_Central_Division", "USSR_South_western", "USSR_Krym",
"USSRSouth_eastern_Division"}

\item{region}{character; a vector of length one with a single region. Only "europe"
and "america" implemented "europe" checks Flora Europaea and only contain plants.
"america" checks ITIS and contain both plant and animals.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data.frame, with species name and result of origin check
}
\description{
This function check the status (native or exotic) of a species in a
given place

For that end, calls \code{\link[taxize]{itis_native}} and \code{\link{fe_native}}.
See help documentation of those functions for details.

So many more things can be done, like checking species first with \pkg{taxize}, adding
more native lists to check...
}
\examples{
\dontrun{
sp <- c("Lavandula stoechas", "Carpobrotus edulis", "Rhododendron ponticum",
       "Alkanna lutea", "Anchusa arvensis")
is_native(sp[1], where = "Islas_Baleares", region = "europe")
lapply(sp, is_native, where = "Continental US", region = "america")
lapply(sp, is_native, where = "Islas_Baleares", region = "europe")

# combine output for many taxa
res <- lapply(sp, is_native, where = "Continental US", region = "america")
library("dplyr")
rbind_all(res)
}
}
\author{
Ignasi Bartomeus \email{nacho.bartomeus@gmail.com}
}

