% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBoxplotTraj.R
\name{plotBoxplotTraj}
\alias{plotBoxplotTraj}
\title{Plot Boxplot of \code{traj} Object}
\usage{
plotBoxplotTraj(x, clust.num = NULL, ...)
}
\arguments{
\item{x}{\code{traj} object.}

\item{clust.num}{Integer indicating the cluster number to plot.\code{NULL} to print all clusters. Defaults to
\code{NULL}.}

\item{...}{Arguments to be passed to plot.}
}
\description{
Produce a boxplot of the values of the trajectories from each cluster at every time points.
}
\details{
The function plots a boxplot of values of the trajectories in a cluster at each time point.
}
\examples{
\dontrun{ 
 # Setup data 
data = example.data$data

# Run step1measures, step2factors and step3clusters with
#a predetermined number of clusters
s1 = step1measures(data, ID=TRUE)
s2 = step2factors(s1)
s3.4clusters = step3clusters(s2, nclust = 4)

 # Plot boxplots
plotBoxplotTraj(s3.4clusters)
}

}
\seealso{
\code{\link[graphics]{boxplot}}
}
\author{
Marie-Pierre Sylvestre, Dan Vatnik

marie-pierre.sylvestre@umontreal.ca
}
