% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{coef.tramME}
\alias{coef.tramME}
\title{Extract the coefficients of the fixed effects terms.}
\usage{
\method{coef}{tramME}(object, with_baseline = FALSE, ...)
}
\arguments{
\item{object}{A tramME object (fitted or unfitted)}

\item{with_baseline}{If TRUE, include the baseline parameters, too.}

\item{...}{Optional parameters (ignored).}
}
\value{
Numeric vector of parameter values.
}
\description{
Extract the coefficients of the fixed effects terms.
}
\examples{
data("sleepstudy", package = "lme4")
mod <- BoxCoxME(Reaction ~ Days + (Days | Subject), data = sleepstudy, nofit = TRUE)
coef(mod, with_baseline = TRUE)
}
