% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightr.R
\name{weightr}
\alias{weightr}
\title{Weights of donor catchments}
\usage{
weightr(Rn, distances, ndonors = 5, donors, power = 1, flexible_donor = TRUE)
}
\arguments{
\item{Rn}{net rainfall matrix of donor catchments (rows for time index, and columns for donors index)}

\item{distances}{vector of the distances to each donor catchment (see \link{hdist})}

\item{ndonors}{maximum number of donor catchments to use}

\item{donors}{vector of catchments id from which donors are selected. If empty, the \code{ndonors} closest
catchments are used}

\item{power}{exponent applied in the inverse distance weighting function (see details)}

\item{flexible_donor}{boolean indicating if the donor catchments can change during the simulation period
according to the availability of discharge observations (see details)}
}
\value{
A matrix with the same dimensions as \code{Rn}.
}
\description{
Estimate the weighting applied at each time step and to each gauged catchment (donors) for the calculation
of the average net rainfall of an ungauged catchment
}
\details{
This function returns a matrix of weights for each time steps (rows) and each gauged catchments
(columns) for the calculation of the average net rainfall of an ungauged catchment (see \link{mixr}).
The weights \eqn{\lambda} are estimated by an inverse distance weighting function \insertCite{deLavenne2016}{transfR}:
\deqn{\lambda_i=\frac{1}{d_i^p}}
\deqn{\Sigma_{i=1}^{ndonors}\lambda_i=1}
where \eqn{d} is the \code{distances} argument and \eqn{p} is the \code{power} argument. The weights are rescaled
so the sum is equal to 1.

Two strategies to handle missing data in the \code{Rn} matrix are possible.
If \code{flexible_donor} is TRUE, donors catchments are redefined at each time steps, and are chosen among
the ones that are effectively gauged at this given time step. This aims to keep a constant number of donor
catchments throughout the simulation period.
If \code{flexible_donor} is FALSE, the donor catchments are chosen once within all the gauged catchments,
regardless of missing data and remain the same throughout the entire simulation period. This stability of
donor catchments might however leads to a reduced number of donors (below \code{ndonors}) during periods
of missing data.
}
\references{
\insertRef{deLavenne2016}{transfR}
}
\seealso{
\link{hdist}, \link{mixr}
}
