% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.treats.R
\name{print.treats}
\alias{print.treats}
\title{Prints a \code{treats} object.}
\usage{
\method{print}{treats}(x, all = FALSE, ...)
}
\arguments{
\item{x}{A \code{treats} object.}

\item{all}{\code{logical}; whether to display the entire object (\code{TRUE}) or just summarise its contents (\code{FALSE} - default).}

\item{...}{further arguments to be passed to \code{print} or to \code{print.treats}.}
}
\value{
No return value, summarises \code{x}'s content.
}
\description{
Summarises the content of a \code{treats} object.
}
\examples{
## A treats birth-death parameters object
make.bd.params()
## A treats traits object
make.traits()
## A treats modifiers object
make.modifiers()
## A treats object
treats(stop.rule = list(max.taxa = 10), traits = make.traits())

}
\seealso{
\code{\link{treats}}
}
\author{
Thomas Guillerme
}
