% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-methods.R
\name{calcOvrlp}
\alias{calcOvrlp}
\title{Calculate phylogenetic overlap}
\usage{
calcOvrlp(tree, ids_1, ids_2, nrmlsd = FALSE, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids_1}{tip ids of community 1}

\item{ids_2}{tip ids of community 2}

\item{nrmlsd}{Boolean, should returned value be between 0 and 1? Default, FALSE.}

\item{...}{\code{plyr} arguments}
}
\description{
Returns the sum of branch lengths represented by ids_1 and ids_2 for a tree.
}
\details{
Use this to calculate the sum of branch lengths that are represented between two
communities. This measure is also known as the unique fraction. It can be used to measure
concepts of phylogenetic turnover. Parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
ids_1 <- sample(tree['tips'], 5)
ids_2 <- sample(tree['tips'], 5)
calcOvrlp(tree, ids_1, ids_2)
}
\references{
Lozupone, C., & Knight, R. (2005). UniFrac: a new phylogenetic method for comparing
microbial communities. Applied and Environmental Microbiology, 71(12), 8228-35.
}
\seealso{
\code{\link{calcPhyDv}}
\url{https://github.com/DomBennett/treeman/wiki/calc-methods}
}

