% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-methods.R
\name{getNdsKids}
\alias{getNdsKids}
\title{Get children IDs for multiple nodes}
\usage{
getNdsKids(tree, ids, ...)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{...}{\code{plyr} arguments}
}
\description{
Return the node ids of all tips that descend from each node in \code{ids}.
}
\details{
Returns a list, parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsKids(tree, id=tree['nds'])
}
\seealso{
\code{\link{getNdKids}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}

