% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setNdOther}
\alias{setNdOther}
\title{Set a user defined slot}
\usage{
setNdOther(tree, id, val, slt_nm)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{id}{id of the node}

\item{val}{data for slot}

\item{slt_nm}{slot name}
}
\description{
Return a tree with a user defined slot for node ID.
}
\details{
A user can specify new slots in a tree. Add a new slot with this function
by providing a node ID, a value for the new slot and a unique new slot name. Slot names
must not be default \code{TreeMan} names. The new value can be any data type.
}
\examples{
library(treeman)
tree <- randTree(10)
tree <- setNdOther(tree, 't1', 1, 'binary_val')
(getNdSlt(tree, id='t1', slt_nm='binary_val'))
}
\seealso{
\code{\link{setNdsOther}}
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}

