% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-grammar}
\alias{node-grammar}
\alias{node_grammar_type}
\alias{node_grammar_symbol}
\title{Node grammar types and symbols}
\usage{
node_grammar_type(x)

node_grammar_symbol(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\description{
\itemize{
\item \code{node_grammar_type()} gets the node's type as it appears in the grammar,
\emph{ignoring aliases}.
\item \code{node_grammar_symbol()} gets the node's symbol (the type as a numeric id)
as it appears in the grammar, \emph{ignoring aliases}. This should be used in
\code{\link[=language_next_state]{language_next_state()}} rather than \code{\link[=node_symbol]{node_symbol()}}.
}
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Examples for these functions are highly specific to the grammar,
# because they relies on the placement of `alias()` calls in the grammar.
node_grammar_type(node)
node_grammar_symbol(node)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=node_type]{node_type()}}, \code{\link[=node_symbol]{node_symbol()}}
}
