% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-parse-state}
\alias{node-parse-state}
\alias{node_parse_state}
\alias{node_next_parse_state}
\title{Node parse states}
\usage{
node_parse_state(x)

node_next_parse_state(x)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}
}
\value{
A single integer representing a parse state.
}
\description{
These are advanced functions that return information about the internal parse
states.
\itemize{
\item \code{node_parse_state()} returns the parse state of the current node.
\item \code{node_next_parse_state()} returns the parse state after this node.
}

See \code{\link[=language_next_state]{language_next_state()}} for more information.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

node <- node_child(node, 1)

# Parse states are grammar dependent
node_parse_state(node)
node_next_parse_state(node)
\dontshow{\}) # examplesIf}
}
