% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CpB.R
\name{CpB}
\alias{CpB}
\title{Calculates the rate of accumulation of phylogenetic B-diversity (CpB) over time slices}
\usage{
CpB(tree, n, mat, adj, comp, method, criterion, pBO, ncor)
}
\arguments{
\item{tree}{phylo. An ultrametric phylogenetic tree in the "phylo" format.}

\item{n}{numeric. A numeric value indicating the number of temporal slices (method = 1) or the time interval in million years (or phylogenetic diversity) among the tree slices (method = 2). Default is 1.}

\item{mat}{matrix. A presence/absence matrix containing all studied species and sites.}

\item{adj}{matrix. A square adjacency matrix containing the presence/absence information of all sites and their spatially adjacent ones.}

\item{comp}{character string. The component of the phylogenetic beta-diversity to obtain the rates of accumulation. It can be either "sorensen", "turnover", or "nestedness". Default is "sorensen".}

\item{method}{character string. The method for calculating the phylogenetic beta-diversity. It can be either obtained through a "pairwise" or "multisite" approach. Default is "multisite".}

\item{criterion}{character string. The method for cutting the tree. It can be either "my" (million years) or "PD" (accumulated phylogenetic diversity). Default is "my".}

\item{pBO}{numeric. A value indicating the numeric proportion to define the temporal origin at which the phylogenetic B-diversity (PB) started to accumulate in a given assemblage. Default is 5\%.}

\item{ncor}{numeric. A value indicating the number of cores the user wants to parallelize. Default is 0.}
}
\value{
The function returns a data frame containing the assemblages' rates of cumulative phylogenetic B-diversity (CpB), their total phylogenetic B-diversity (PB), and their PB origin (pBO).
}
\description{
This function estimates the rates of accumulation of phylogenetic B-diversity (CpB) over time for inputted assemblages.
}
\details{
\bold{Parallelization}

Users are advised to check the number of available cores within their machines before running parallel programming.
}
\examples{
# Generate a random tree
tree <- ape::rcoal(20)

# Create a presence-absence matrix
mat <- matrix(sample(c(1,0), 20*10, replace = TRUE), ncol = 20, nrow = 10)
colnames(mat) <- tree$tip.label

# Create a random adjacency matrix
adj <- matrix(sample(c(1,0), 10*10, replace = TRUE), ncol = 10, nrow = 10)

# Fill the diagonals with 1
diag(adj) <- 1

# Calculate their CpB (sorensen) for 100 tree slices
CpB(tree, n = 100, mat = mat, adj = adj, comp = "sorensen", method = "multisite")

}
\references{
See the tutorial on how to use this function on our \href{https://araujomat.github.io/treesliceR/articles/Passeriformes-diversification.html}{website}.
}
\seealso{
Other cumulative phylogenetic index analysis: \code{\link[=CpD]{CpD()}}, \code{\link[=CpE]{CpE()}}, \code{\link[=CpB_RW]{CpB_RW()}}
}
\author{
Matheus Lima de Araujo \href{mailto:matheusaraujolima@live.com}{matheusaraujolima@live.com}
}
