% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcars.R
\name{scale_lcars}
\alias{scale_lcars}
\alias{scale_color_lcars}
\alias{scale_color_lcars1}
\alias{scale_color_lcars2}
\alias{scale_fill_lcars}
\alias{scale_fill_lcars1}
\alias{scale_fill_lcars2}
\title{Color and fill scale functions for LCARS colors}
\usage{
scale_color_lcars(palette = "2357", discrete = TRUE, reverse = FALSE, ...)

scale_color_lcars1(
  color = "atomic-tangerine",
  discrete = TRUE,
  reverse = FALSE,
  dark = FALSE,
  ...
)

scale_color_lcars2(
  low = "atomic-tangerine",
  high = "near-blue",
  discrete = TRUE,
  reverse = FALSE,
  dark = FALSE,
  divergent = FALSE,
  ...
)

scale_fill_lcars(palette = "2357", discrete = TRUE, reverse = FALSE, ...)

scale_fill_lcars1(
  color = "atomic-tangerine",
  discrete = TRUE,
  reverse = FALSE,
  dark = FALSE,
  ...
)

scale_fill_lcars2(
  low = "atomic-tangerine",
  high = "near-blue",
  discrete = TRUE,
  reverse = FALSE,
  dark = FALSE,
  divergent = FALSE,
  ...
)
}
\arguments{
\item{palette}{character, name of palette in \code{lcars_pals}.}

\item{discrete}{logical, discrete or continuous palette.}

\item{reverse}{logical, reverse color order.}

\item{...}{additional arguments passed to \code{ggplot2::discrete_scale} or \code{ggplot2::scale_*_gradientn}, for discrete or continuous palettes, respectively.}

\item{color}{character, LCARS color name for sequential palette.}

\item{dark}{logical, use black instead of white for the base color in sequential palette or midpoint in divergent palette.}

\item{low}{character, LCARS color name.}

\item{high}{character, LCARS color name.}

\item{divergent}{logical, use a divergent palette instead of two-color sequential palette.}
}
\description{
Scale functions used with ggplot2.
}
\examples{
library(ggplot2)
p <- ggplot(diamonds, aes(carat, stat(count), fill = cut)) +
  geom_density(position = "fill")
p + scale_fill_lcars("2357")
p + scale_fill_lcars1("atomic-tangerine", dark = TRUE)
p + scale_fill_lcars2("pale-canary", "danub")
}
