% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csmk.test.R
\name{csmk.test}
\alias{csmk.test}
\title{Correlated Seasonal Mann-Kendall Test}
\usage{
csmk.test(x, alternative = c("two.sided", "greater", "less"))
}
\arguments{
\item{x}{a time series object with class \code{ts} comprising >= 2 seasons;
\code{NA} values are not allowed}

\item{alternative}{the alternative hypothesis, defaults to \code{two.sided}}
}
\value{
An object with class "htest"
\item{data.name}{character string that denotes the input data}
\item{p.value}{the p-value for the entire series}
\item{statistic}{the z quantile of the standard normal distribution
for the entire series}
\item{null.value}{the null hypothesis}
\item{estimates}{the estimates S and varS for the entire series}
\item{alternative}{the alternative hypothesis}
\item{method}{character string that denotes the test}
\item{cov}{the variance - covariance matrix}
}
\description{
Performs a Seasonal Mann-Kendall test under the presence of correlated
 seasons.
}
\details{
{

 The Mann-Kendall scores are first computed for each season seperately.
 The variance - covariance matrix is computed according to Libiseller and Grimvall (2002).
 Finally the corrected Z-statistics for the entire series
 is calculated as follows, whereas a continuity correction is employed
 for \eqn{n \le 10}{n <= 10}:

 \deqn{
   z = \frac{\mathbf{1}^T \mathbf{S}}
   {\sqrt{\mathbf{1}^T \mathbf{\Gamma}~\mathbf{1}}}
   }{%
   z = 1^T S / sqrt(1^T \Gamma 1)
   }

 where

 \eqn{z} denotes the quantile of the normal distribution, 1 indicates a vector
 with all elements equal to one, \eqn{\mathbf{S}} is the vector of Mann-Kendall scores
 for each season and \eqn{\mathbf{\Gamma}}} denotes the variance - covariance matrix.
}
\note{
Ties are not corrected. Current Version is for complete observations only.
}
\examples{
csmk.test(nottem)
}
\references{
Hipel, K.W. and McLeod, A.I. (2005),
\emph{Time Series Modelling of Water Resources and Environmental Systems}.
Electronic reprint of our book orginally published in 1994.
\url{http://www.stats.uwo.ca/faculty/aim/1994Book/}.

Libiseller, C. and Grimvall, A. (2002),
Performance of partial Mann-Kendall tests for trend detection in the
presence of covariates. \emph{Environmetrics} 13, 71-84, \url{http://dx.doi.org/10.1002/env.507}.
}
\seealso{
\code{\link{cor}},
\code{\link{cor.test}},
\code{\link{mk.test}},
\code{\link{smk.test}}
}
\keyword{multivariate}
\keyword{nonparametric}
\keyword{ts}
