% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efftox_dtps_to_dataframe.R
\name{efftox_dtps_to_dataframe}
\alias{efftox_dtps_to_dataframe}
\title{Calculate dose-transition pathways for an EffTox study}
\usage{
efftox_dtps_to_dataframe(dat, cohort_sizes, next_dose, ...)
}
\arguments{
\item{dat}{An instance of \code{\link{efftox_params}}, a list of EffTox
parameters. An example is yielded by \code{\link{efftox_parameters_demo}}.}

\item{cohort_sizes}{vector of future cohort sizes, i.e. positive integers.
E.g. To calculate paths for the the next cohort of two followed by another
cohort of three, use \code{cohort_sizes = c(2, 3)}.}

\item{next_dose}{the dose-level to be given to the immediately next cohort.}

\item{...}{extra params passed to \code{rstan::sampling}.}
}
\value{
dose pathways in a \code{data.frame}.
}
\description{
Calculate dose-transition pathways for an EffTox study.
Note that TODO TODO TODO
}
\examples{
# Calculate the paths for the first cohort of 3 in Thall et al 2014 example
dat <- efftox_parameters_demo()
\dontrun{
dtps1 <- efftox_dtps_to_dataframe(dat = dat, cohort_sizes = c(3),
                                  next_dose = 1)
}
# To calculate future paths in a partially-observed trial
dat <- efftox_parameters_demo()
dat$doses = array(c(1,1,1))
dat$eff = array(c(0,0,0))
dat$tox = array(c(1,1,1))
dat$num_patients = 3
\dontrun{
dtps2 <- efftox_dtps_to_dataframe(dat = dat, cohort_sizes = c(3),
                                  next_dose = 1)
}

}
\references{
Brock K, Billingham L, Copland M, Siddique S, Sirovica M, Yap C.
Implementing the EffTox dose-finding design in the Matchpoint trial.
BMC Medical Research Methodology. 2017;17(1):112.
doi:10.1186/s12874-017-0381-x
}
\seealso{
\code{\link{efftox_dtps}}, \code{\link{efftox_params}},
\code{\link{efftox_parameters_demo}}
}
