% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_tox_exceeds.R
\name{prob_tox_exceeds}
\alias{prob_tox_exceeds}
\alias{prob_tox_exceeds.dose_finding_fit}
\title{Calculate the probability that the rate of toxicity exceeds some threshold}
\usage{
prob_tox_exceeds(x, ...)

\method{prob_tox_exceeds}{dose_finding_fit}(x, threshold, ...)
}
\arguments{
\item{x}{an R object of class \code{"dose_finding_fit"}}

\item{...}{arguments passed to other methods}

\item{threshold}{numeric, threshold value.}
}
\value{
numerical vector of probabilities

numerical vector of probabilities
}
\description{
Calculate the probability that the rate of toxicity exceeds some threshold

Calculate the probability that the rate of toxicity exceeds some threshold
}
\examples{
\dontrun{
# CRM example
target <- 0.2
fit <- stan_crm('1N 2N 3T', skeleton = c(0.1, 0.2, 0.35, 0.6),
                 target = target, model = 'empiric', beta_sd = sqrt(1.34),
                 seed = 123)
prob_tox_exceeds(fit, target)
}
}
