% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eff_at_dose.R
\name{eff_at_dose}
\alias{eff_at_dose}
\alias{eff_at_dose.efftox_fit}
\title{Get the number of efficacy events seen at the doses under investigation.}
\usage{
eff_at_dose(x, dose, ...)

\method{eff_at_dose}{efftox_fit}(x, dose = NULL, ...)
}
\arguments{
\item{x}{An R object of class \code{"dose_finding_fit"}}

\item{dose}{Optional integer, at which dose-level? Omit to get data on all doses.}

\item{...}{arguments passed to other methods}
}
\value{
integer vector
}
\description{
Get the number of efficacy events seen at the doses under investigation.
}
\examples{
\dontrun{
# EffTox example
x <- stan_efftox_demo(outcome_str = '1N 2E')
eff_at_dose(fit)            # c(0, 1, 0, 0)
eff_at_dose(fit, dose = 2)  # 1
eff_at_dose(fit, dose = 3)  # 0
}
}
