% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.R
\name{power_equiv}
\alias{power_equiv}
\title{Power Simulation For Equivalence Test}
\usage{
power_equiv(phase_eff, delta, target_effect, nsubj, nruns, outfile = ".AUTO.")
}
\arguments{
\item{phase_eff}{A four-element vector, each element of which
specifies the illusory truth effect at the corresponding phase,
on the log odds scale (see \code{\link{gen_data}}).}

\item{delta}{Smallest (raw) effect size of interest, on log odds
scale; \code{NULL} to store fitted model object.}

\item{target_effect}{Which effect to test, the main effect
(\code{'main'}) or the interaction effect (\code{'interaction'}).}

\item{nsubj}{Number of subjects.}

\item{nruns}{How many simulations to run.}

\item{outfile}{One of three options: (1) file name to save the
results in (with extension .rds); (2) ".AUTO." to create a
descriptive filename automatically; or (3) \code{NULL} to return
the results of the simulation.}
}
\value{
Either the name of the file where results are saved or a
  matrix containing results of \code{\link{fit_lmem}} or
  \code{\link{fit_clmm}}).
}
\description{
Power Simulation For Equivalence Test
}
\examples{
set.seed(62)

\donttest{
## takes a few minutes to complete
power_equiv(c(0, .14, .14, .14), .1, "main", 24, 1, NULL) 
}
}
