% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{truth_trajectory_design}
\alias{truth_trajectory_design}
\alias{stimulus_materials}
\alias{stimulus_categories}
\alias{stimulus_conditions}
\alias{presentation_lists}
\title{Design of the Longitudinal Illusory Truth Study}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 128 rows and 3 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 170 rows and 3 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1024 rows and 4 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 1536 rows and 5 columns.
}
\usage{
stimulus_materials

stimulus_categories

stimulus_conditions

presentation_lists
}
\description{
A collection of four data frames in tidy format that contain
information about stimuli and experimental design for
\insertCite{Henderson_Simons_Barr_2021;textual}{truthiness}.
}
\details{
Each data frame contains a subset of the following 11 variables:

\describe{
  \item{\code{stim_id}}{Unique identifier of the stimulus.}

  \item{\code{statement}}{The statement.}

  \item{\code{actual_truth}}{Actual truth or falsity of the statement.}

  \item{\code{choice}}{Category number; allows for more than one correct categorization.}

  \item{\code{category}}{Name of category.}

  \item{\code{list_id}}{Unique identifier of stimulus presentation list.}

  \item{\code{repetition}}{Whether the statement was repeated or novel.}

  \item{\code{interval}}{Interval (phase) in which the truth-rating was
  performed (immediate = 1, 1 day = 2, 1 week = 3, 1 month = 4).}

  \item{\code{phase_id}}{Phase (1-4) in which the stimulus will be presented.}

  \item{\code{task}}{Which task the stimulus is presented in (categorize
  or rate truth).}

  \item{\code{task_id}}{Unique identifier of the task/stimulus combination.}
}

The \code{stimulus_materials} data frame lists all 128 trivia
statements used in the study. These statements were adapted from
\insertCite{Nadarevic2014;textual}{truthiness} and
\insertCite{Dekeersmaecker2019;textual}{truthiness}, who in turn
adapted their materials from those original compiled by
\insertCite{Unkelbach_Rom_2017;textual}{truthiness}. Each stimulus is
given a unique identifier, \code{stim_id}, that appears across
related tables.

The \code{stimulus_categories} data frame gives information about
which category each stimulus statement belongs to. Note that each
statement can belong to more than one category simultaneously.

The \code{stimulus_conditions} data frame provides a 'lookup' table
that associates each stimulus (\code{stim_id}) from each
presentation list (\code{list_id}) with its experimental conditions
(\code{repetition}, and \code{interval}).

There were eight separate presentation lists used in the study for
counterbalancing purposes. These lists are provided in
the \code{presentation_lists} data frame.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
