% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/TVAR.sim.R
\name{TVAR.boot}
\alias{TVAR.boot}
\title{Bootstrap a multivariate Threshold Autoregressive (TVAR) model}
\usage{
TVAR.boot(TVARobject, innov, seed, ...)
}
\arguments{
\item{TVARobject}{Object of class \code{TVAR} generated by function
\code{\link{TVAR}}}

\item{innov}{Innovations used for bootstrap. If missing, residuals are
resampled.}

\item{seed}{Optional. Seed for the random resampling function.}

\item{\dots}{Further arguments passed to the underlying (un-exported)
\code{TVAR.gen} function}
}
\value{
A matrix with the bootstraped series.
}
\description{
Recursive bootstrap of a multivariate Threshold VAR (TVAR)
}
\details{
The function bootstraps a given model. This is done on a object generated by
TVECM (or VECM). A simple residual recursive bootstrap is done.
}
\examples{
##Bootstrap a TVAR with two threshold (three regimes)
data(zeroyld)
serie<-zeroyld
mod <- TVAR(data=serie,lag=1, nthresh=1)
TVAR.boot(mod)
}
\author{
Matthieu Stigler
}
\seealso{
\code{\link{TVAR}} to estimate a TVAR, \code{\link{VAR.sim}} to
simulate/bootstrap a VAR, \code{\link{TVECM.sim}} to simulate/bootstrap a
TVECM.
}
\keyword{bootstrap}
\keyword{ts}

