% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_na_omit.R
\name{ts_na_omit}
\alias{ts_na_omit}
\title{Omit NA values}
\usage{
ts_na_omit(x)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo},
\code{zooreg}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis},
\code{irts} or \code{timeSeries}.}
}
\value{
a ts-boxable object of the same class as \code{x}, i.e., an object of
class \code{ts}, \code{xts}, \code{zoo}, \code{zooreg}, \code{data.frame}, \code{data.table}, \code{tbl},
\code{tbl_ts}, \code{tbl_time}, \code{tis}, \code{irts} or \code{timeSeries}.
}
\description{
Remove NA values in ts-boxable objects, turning explicit into implicit
missing values.
}
\details{
Note that internal NAs in \code{ts} time series will not be removed, as this
conflicts with the regular structure.
}
\examples{
x <- AirPassengers
x[c(2, 4)] <- NA

# A ts object does only know explicit NAs
ts_na_omit(x)

# by default, NAs are implicit in data frames
ts_df(x)

# make NAs explicit
ts_regular(ts_df(x))

# and implicit again
ts_na_omit(ts_regular(ts_df(x)))
}
\seealso{
\link{ts_regular}, for the opposite, turning implicit into explicit
missing values.
}
