% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{n_training_examples}
\alias{n_training_examples}
\title{Number of training examples}
\usage{
n_training_examples(timeS, h, lags, msas = c("MIMO", "recursive"))
}
\arguments{
\item{timeS}{A numeric vector or time series of class \code{ts}.}

\item{h}{A positive integer. Number of values to forecast.}

\item{lags}{An integer vector in increasing order expressing the lags used
as autoregressive variables.}

\item{msas}{A string indicating the Multiple-Step Ahead Strategy used when
more than one value is predicted. It can be "recursive" or "MIMO" (the
default).}
}
\value{
An integer.
}
\description{
It computes the number of training examples that would have a KNN model
with the specified parameters.
}
\examples{
n_training_examples(ts(1:10), h = 2, lags = 1:3, msas = "MIMO")
n_training_examples(ts(1:10), h = 2, lags = 1:3, msas = "recursive")
}
