% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-index.R
\name{time_in}
\alias{time_in}
\title{If time falls in the ranges using compact expressions}
\usage{
time_in(x, ...)
}
\arguments{
\item{x}{A vector of time index, such as classes \code{POSIXct}, \code{Date}, \code{yearweek},
\code{yearmonth}, \code{yearquarter}, \code{hms}/\code{difftime}, and \code{numeric}.}

\item{...}{Formulas that specify start and end periods (inclusive) or strings.
\itemize{
\item \code{~ end} or \code{. ~ end}: from the very beginning to a specified ending period.
\item \code{start ~ end}: from specified beginning to ending periods.
\item \code{start ~ .}: from a specified beginning to the very end of the data.
Supported index type: \code{POSIXct} (to seconds), \code{Date}, \code{yearweek}, \code{yearmonth}/\code{yearmon},
\code{yearquarter}/\code{yearqtr}, \code{hms}/\code{difftime} & \code{numeric}.
}}
}
\value{
logical vector
}
\description{
\Sexpr[results=rd, stage=render]{tsibble:::lifecycle("maturing")}

This function respects time zone and encourages compact expressions.
}
\section{System Time Zone ("Europe/London")}{

There is a known issue of an extra hour gained for a machine setting time
zone to "Europe/London", regardless of the time zone associated with
the POSIXct inputs. It relates to \emph{anytime} and \emph{Boost}. Use \code{Sys.timezone()}
to check if the system time zone is "Europe/London". It would be recommended to
change the global environment "TZ" to other equivalent names: GB, GB-Eire,
Europe/Belfast, Europe/Guernsey, Europe/Isle_of_Man and Europe/Jersey as
documented in \code{?Sys.timezone()}, using \code{Sys.setenv(TZ = "GB")} for example.
}

\examples{
x <- unique(pedestrian$Date_Time)
lgl <- time_in(x, ~"2015-02", "2015-08" ~ "2015-09", "2015-12" ~ "2016-02")
lgl[1:10]
# more specific
lgl2 <- time_in(x, "2015-03-23 10" ~ "2015-10-31 12")
lgl2[1:10]

library(dplyr)
pedestrian \%>\%
  filter(time_in(Date_Time, "2015-03-23 10" ~ "2015-10-31 12"))
pedestrian \%>\%
  filter(time_in(Date_Time, "2015")) \%>\%
  mutate(Season = ifelse(
    time_in(Date_Time, "2015-03" ~ "2015-08"),
    "Autumn-Winter", "Spring-Summer"
  ))
}
\seealso{
\link{filter_index} for filtering tsibble
}
