% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate.tsissm.estimate}
\alias{simulate.tsissm.estimate}
\alias{simulate}
\alias{simulate.tsissm.selection}
\title{Model Simulation}
\usage{
\method{simulate}{tsissm.estimate}(
  object,
  nsim = 1,
  seed = NULL,
  h = 1,
  newxreg = NULL,
  sim_dates = NULL,
  bootstrap = FALSE,
  innov = NULL,
  innov_type = "q",
  pars = coef(object),
  init_states = tail(object$model$states, 1),
  init_res = NULL,
  init_sigma = NULL,
  ...
)

\method{simulate}{tsissm.selection}(
  object,
  nsim = 1,
  seed = NULL,
  h = 1,
  newxreg = NULL,
  sim_dates = NULL,
  bootstrap = FALSE,
  pars = coef(object),
  init_states = tail(object$model$states, 1),
  init_res = NULL,
  init_sigma = NULL,
  ...
)
}
\arguments{
\item{object}{an object of class \dQuote{tsissm.estimate}.}

\item{nsim}{the number of paths per complete set of time steps (h).}

\item{seed}{a value specifying if and how the random number generator should be
initialized (\sQuote{seeded}). Either NULL or an integer that will be used in
a call to set.seed before simulating the response vectors.}

\item{h}{the number of time steps to simulate paths for. If this is NULL,
it will use the same number of periods as in the original series.}

\item{newxreg}{an optional matrix of regressors to use for the simulation
if xreg was used in the estimation. If NULL and the estimated object had
regressors, and h was also set to NULL, then the original regressors will
be used.}

\item{sim_dates}{an optional vector of simulation dates equal to h. If NULL
will use the implied periodicity of the data to generate a regular sequence
of dates after the first available date in the data.}

\item{bootstrap}{whether to bootstrap the innovations from the estimated
object by re-sampling from the empirical distribution.}

\item{innov}{an optional vector of innovations (see innov_type). 
The length of this vector should be equal to nsim x horizon.}

\item{innov_type}{if \sQuote{innov} is not NULL, then this denotes the type of values
passed, with \dQuote{q} denoting quantile probabilities (default and
backwards compatible) and \dQuote{z} for standardized errors.}

\item{pars}{an optional named vector of model coefficients which override the
estimated coefficients. No checking is currently performed on the adequacy of
these coefficients.}

\item{init_states}{An optional vector of states to initialize the forecast. 
If NULL, will use the first available states from the estimated model.}

\item{init_res}{For a dynamic variance model, the initialization for the
ARCH recursion of length equal to max(p,q).}

\item{init_sigma}{For a dynamic variance model, the standard deviation initialization 
for the GARCH recursion of length equal to max(p,q).}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tsissm.simulate} with slots for the simulated
series and states.
}
\description{
Simulation function for class \dQuote{tsissm.estimate}.
}
