% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fluss.R
\name{fluss_cac}
\alias{fluss_cac}
\title{FLUSS - Corrected Arc Counts}
\usage{
fluss_cac(.mp, exclusion_zone = NULL)
}
\arguments{
\item{.mp}{a TSMP object of class \code{MatrixProfile}.}

\item{exclusion_zone}{if a \code{number} will be used instead of embedded value. (Default is \code{NULL}).}
}
\value{
Returns the input \code{.mp} object a new name \code{cac} with the corrected arc count.
}
\description{
Computes the arc count with edge correction (CAC).
}
\details{
Original paper suggest using the classic statistical-process-control heuristic to set a threshold
where a semantic change may occur in CAC. This may be useful in real-time implementation as we don't
know in advance the number of domain changes to look for. Please check original paper (1).
}
\examples{
data <- mp_fluss_data$tilt_abp$data[1:1000]
w <- 10
mp <- tsmp(data, window_size = w, verbose = 0)
mp <- fluss_cac(mp)
}
\references{
\itemize{
\item Gharghabi S, Ding Y, Yeh C-CM, Kamgar K, Ulanova L, Keogh E. Matrix Profile VIII: Domain Agnostic Online Semantic Segmentation at Superhuman Performance Levels. In: 2017 IEEE International Conference on Data Mining (ICDM). IEEE; 2017. p. 117–26.
}

Website: \url{https://sites.google.com/site/onlinesemanticsegmentation/}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other Semantic Segmentations: \code{\link{fluss_extract}},
  \code{\link{fluss_score}}, \code{\link{fluss}}
}
\concept{Semantic Segmentations}
