% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{av_complexity}
\alias{av_complexity}
\title{Computes the annotation vector that favors complexity}
\usage{
av_complexity(.mp, data, dilution_factor = 0, apply = FALSE)
}
\arguments{
\item{.mp}{a Matrix Profile object.}

\item{data}{a \code{vector} or a column \code{matrix} of \code{numeric}.}

\item{dilution_factor}{a \code{numeric}. (Default is \code{0}). Larger numbers means more dilution.}

\item{apply}{logical. (Default is \code{FALSE}). Applies the Annotation Vector over the Matrix Profile.
Use with caution.}
}
\value{
Returns the input \code{.mp} object with an embedded annotation vector.
}
\description{
Computes the annotation vector that favors complexity
}
\examples{
data <- mp_test_data$train$data[1:1000]
w <- 50
mp <- tsmp(data, window_size = w, verbose = 0)
av <- av_complexity(mp, apply = TRUE)
}
\references{
\itemize{
\item Dau HA, Keogh E. Matrix Profile V: A Generic Technique to Incorporate Domain
Knowledge into Motif Discovery. In: Proceedings of the 23rd ACM SIGKDD International Conference
on Knowledge Discovery and Data Mining - KDD '17. New York, New York, USA: ACM Press; 2017. p.
125-34.
}
}
\seealso{
Other Annotation vectors: 
\code{\link{av_apply}()},
\code{\link{av_hardlimit_artifact}()},
\code{\link{av_motion_artifact}()},
\code{\link{av_stop_word}()},
\code{\link{av_zerocrossing}()}
}
\concept{Annotation vectors}
