% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-snippet.R
\name{find_snippet}
\alias{find_snippet}
\title{Time Series Snippets: A New Primitive for Time Series Data Mining}
\usage{
find_snippet(data, s_size, n_snippets = 2L, window_size = s_size/2L)
}
\arguments{
\item{data}{a \code{matrix} or a \code{vector}.}

\item{s_size}{an int. Size of snippet.}

\item{n_snippets}{an \code{int}. Number of snippets to find. (Default is \code{2}).}

\item{window_size}{an \code{int}. The size of the sliding window used to compare the data. Must be smaller
than \code{s_size}. (Default is \code{s_size / 2}).}
}
\value{
Returns the snippet : a list of n_snippets snippets
fraction : fraction of each snippet
snippetidx : the location of each
snippet within time series
}
\description{
Time Series Snippets tries to solve mainly the common problem of summarization "Show me some
representative/typical data". As stated by the original paper, potential uses of snippets are:
integrating summarizations of files directly into an operating, production of automatically
generated reports, for example, summarize a sleep study and also can be used to support a
host of higher-level tasks, including the comparison of massive data collections.
}
\details{
Motifs vs. snippets: While motifs reward fidelity of conservation, snippets also rewards coverage.
Informally, coverage is some measure of how much of the data is explained or represented by
a given snippet.

Shapelets vs. snippets: shapelets are defined as subsequences that are maximally representative
of a class. Shapelets are supervised, snippets are unsupervised. Shapelets are generally biased
to be as short as possible. In contrast, we want snippets to be longer, to intuitively capture
the "flavor" of the time series.
}
\examples{

snippets <- find_snippet(mp_fluss_data$walkjogrun$data[1:300], 40, n_snippets = 2)
\dontrun{
snippets <- find_snippet(mp_fluss_data$walkjogrun$data, 120, n_snippets = 3)
plot(snippets)
}

}
\references{
\itemize{
\item Imani S, Madrid F, Ding W, Crouter S, Keogh E. Matrix Profile XIII:
Time Series Snippets: A New Primitive for Time Series Data Mining. In: 2018 IEEE International
Conference on Data Mining (ICDM). 2018.
}

\itemize{
\item Gharghabi S, Imani S, Bagnall A, Darvishzadeh A, Keogh E. Matrix Profile XII:
MPdist: A Novel Time Series Distance Measure to Allow Data Mining in More Challenging Scenarios.
In: 2018 IEEE International Conference on Data Mining (ICDM). 2018.
}

Website: \url{https://sites.google.com/site/snippetfinder/}
}
