% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_plot.R
\name{posterior_plot}
\alias{posterior_plot}
\title{posterior_plot}
\usage{
posterior_plot(fitobj, mat = "beta", cis = c(0.8, 0.9, 0.95))
}
\arguments{
\item{fitobj}{Fitted model object. This can be a tsnet_fit object (obtained
from [stan_gvar()]) or a BGGM object (obtained from [BGGM::var_estimate()]).}

\item{mat}{A matrix to use for plotting. Possibilities include "beta"
(temporal network) and "pcor" (contemporaneous network). Default is "beta"
(temporal network).}

\item{cis}{A numeric vector of credible intervals to use for plotting.
Default is c(0.8, 0.9, 0.95).}
}
\value{
A ggplot object representing the posterior distributions of the parameters of the temporal
or the contemporaneous networks of a GVAR model.
}
\description{
Plots posterior distributions of the parameters of the temporal
or the contemporaneous networks of a GVAR model. The posterior distributions
are visualized as densities in a matrix layout.
}
\details{
In the returned plot, posterior distributions for every parameter
are shown. Lagged variables are displayed along the vertical line of the
grid, and non-lagged variables along the horizontal line of the grids.
}
\examples{
\donttest{
# Load simulated time series data
data(ts_data)
example_data <- ts_data[1:100,1:4]

# Estimate a GVAR model
fit <- stan_gvar(example_data, n_chains = 2)

# Extract posterior samples
posterior_plot(fit)
}
}
