% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_elm.R
\name{ts_elm}
\alias{ts_elm}
\title{ELM}
\usage{
ts_elm(preprocess = NA, input_size = NA, nhid = NA, actfun = "purelin")
}
\arguments{
\item{preprocess}{normalization}

\item{input_size}{input size for machine learning model}

\item{nhid}{ensemble size}

\item{actfun}{defines the type to use, possible values: 'sig',
'radbas', 'tribas', 'relu', 'purelin' (default).}
}
\value{
returns a \code{ts_elm} object.
}
\description{
Creates a time series prediction object that
uses the Extreme Learning Machine (ELM).
It wraps the elmNNRcpp library.
}
\examples{
library(daltoolbox)
data(sin_data)
ts <- ts_data(sin_data$y, 10)
ts_head(ts, 3)

samp <- ts_sample(ts, test_size = 5)
io_train <- ts_projection(samp$train)
io_test <- ts_projection(samp$test)

model <- ts_elm(ts_norm_gminmax(), input_size=4, nhid=3, actfun="purelin")
model <- fit(model, x=io_train$input, y=io_train$output)

prediction <- predict(model, x=io_test$input[1,], steps_ahead=5)
prediction <- as.vector(prediction)
output <- as.vector(io_test$output)

ev_test <- evaluate(model, output, prediction)
ev_test
}
