% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_ean.R
\name{ts_norm_ean}
\alias{ts_norm_ean}
\title{Time Series Adaptive Normalization (Exponential Moving Average - EMA)}
\usage{
ts_norm_ean(outliers = outliers_boxplot(), nw = 0)
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}

\item{nw}{windows size}
}
\value{
returns a \code{ts_norm_ean} object.
}
\description{
Creates a normalization object for time series data using an Exponential Moving Average (EMA) method.
This normalization approach adapts to changes in the time series and optionally removes outliers.
}
\examples{
# time series to normalize
library(daltoolbox)
data(tsd)

# convert to sliding windows
ts <- ts_data(tsd$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# normalization
preproc <- ts_norm_ean()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
