% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vreq_LdM.R
\name{vreq_LdM}
\alias{vreq_LdM}
\title{Creator function of \code{vreq_LdM} S3 class}
\usage{
vreq_LdM(X)
}
\arguments{
\item{X}{A matrix with counts or densities arranged in species by years}
}
\value{
\code{vreq_LdM} returns a \code{vreq_LdM} object. Slots are:
\item{com}{the squared community CV, CVcom2}
\item{comnull}{CVpop2}
\item{vr}{the L-dM variance ratio}
}
\description{
The \code{vreq_LdM} (variance ratio equation, Loreau-de Mazancourt variance ratio) class is for 
storing equations based on the L-dM variance ratio. Inherits from the \code{vreq} class,
which inherits from the \code{list} class.
}
\examples{
X<-matrix(runif(10*100),10,100)
res<-vreq_LdM(X)

}
\references{
Loreau & Mazancourt, Species Synchrony and Its Drivers: Neutral and Nonneutral Community 
Dynamics in Fluctuating Environments. 2008, Am. Nat. 172(2)
}
\seealso{
\code{\link{vreq_LdM_methods}}, \code{\link{vreq_classic}}, \code{\link{vreq}},
\code{browseVignettes("tsvr")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
