% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vreq_classic.R
\name{vreq_classic}
\alias{vreq_classic}
\title{Creator function of \code{vreq_classic} S3 class}
\usage{
vreq_classic(X)
}
\arguments{
\item{X}{A matrix with counts or densities arranged in species by years}
}
\value{
\code{vreq_classic} returns a \code{vreq_classic} object. Slots are:
\item{com}{the squared community CV, CVcom2}
\item{comnull}{CVcomip2}
\item{vr}{the classic variance ratio}
}
\description{
The \code{vreq_classic} (variance ratio equation, classic variance ratio) class is for 
storing equations based on the classic variance ratio. Inherits from the \code{vreq} class,
which inherits from the \code{list} class.
}
\examples{
X<-matrix(runif(10*100),10,100)
res<-vreq_classic(X)

}
\references{
Peterson (1975) Stability of species and of community for the benthos of two lagoons. Ecology 56, 958-965.
}
\seealso{
\code{\link{vreq_classic_methods}}, \code{\link{vreq}}, \code{\link{vreq_LdM}}, 
\code{\link{vreq_classic_ag_methods}}, \code{browseVignettes("tsvr")}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
