% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppdist.R
\name{sumppdist}
\alias{sumppdist}
\title{Compute Sum of q-th Powers of Distances Between a Point Pattern and a List of Point Patterns}
\usage{
sumppdist(
  zeta,
  pplist,
  penalty = 1,
  type = c("tt", "rtt", "TT", "RTT"),
  p = 1,
  q = 1
)
}
\arguments{
\item{zeta}{an object of class \code{\link[=ppp]{ppp}}.}

\item{pplist}{an object of class \code{\link[=solist]{ppplist}} or an 
object that can be coerced to this class, such as a list of \code{\link[=ppp]{ppp}}
objects.}

\item{penalty}{a positive number. The penalty for adding/deleting points.}

\item{type}{either \code{"tt"}/\code{"TT"} for the transport-transform metric
or \code{"rtt"}/\code{"RTT"} for the relative transport-transform metric.}

\item{p}{a number \eqn{>0}. Matchings between \code{zeta} and the patterns in
\code{pplist} are chosen such that the \code{p}-th order sums (\eqn{\ell_p}{l_p}-norms)
of the Euclidean distances are minimized.}

\item{q}{a number \eqn{>0}.}
}
\value{
A nonnegative number, the \code{q}-th order sum of the TT-p- or RTT-p-distances 
        between \code{zeta} and each pattern in \code{pplist}. This number has an attribute
        \code{distances} that contains the individual distances.
}
\description{
Determine the Euclidean distance based TT-p-distances (or RTT-p-distances) between
a single point pattern \code{zeta} and each point pattern in a list \code{pplist}. Then
compute the sum of \eqn{q}-th powers of these distances.
}
\details{
The main purpose of this function is to evaluate the relative performance
        of approximate \eqn{q}-th order barycenters of point patterns. A true 
        \eqn{q}-th order barycenter of the point patterns \eqn{\xi_1,\ldots,\xi_k}{xi_1, ..., xi_k}
        with respect to the TT-p metric \eqn{\tau_p}{tau_p} minimizes 
        \deqn{\sum_{j=1}^k \tau_p(\xi_j, \zeta)^q}{sum_{j=1}^k tau_p(xi_j, zeta)^q}
        in \eqn{\zeta}{zeta}.      
        
        The most common choices are \code{p = q = 1} and \code{p = q = 2}. Other
        choices have not been tested.
}
\examples{
  # See the examples for kmeansbary
  
}
\seealso{
\code{\link{ppdist}} for computation of TT-p- and RTT-p-metrics,\cr
         \code{\link{kmeansbary}} for finding a local minimum of the above sum for \code{p = q = 2}
}
\author{
Dominic Schuhmacher \email{schuhmacher@math.uni-goettingen.de}
}
