% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_related_videos.R
\name{get_related_videos}
\alias{get_related_videos}
\title{Get Related Videos}
\usage{
get_related_videos(video_id = NULL, max_results = 50,
  safe_search = "none", ...)
}
\arguments{
\item{video_id}{Character. Required. No default.}

\item{max_results}{Maximum number of items that should be returned. Integer. Optional. Can be between 0 and 50. Default is 50.}

\item{safe_search}{Character. Optional. Takes one of three values: \code{'moderate'}, \code{'none'} (default) or \code{'strict'}}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
\code{data.frame} with 16 columns: \code{video_id, publishedAt, channelId, title, description, 
thumbnails.default.url, thumbnails.default.width, thumbnails.default.height, thumbnails.medium.url, 
thumbnails.medium.width, thumbnails.medium.height, thumbnails.high.url, thumbnails.high.width, 
thumbnails.high.height, channelTitle, liveBroadcastContent}
}
\description{
Takes a video id and returns related videos
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

get_related_videos(video_id="yJXTXN4xrI8")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/search/list}
}

