% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_channel_videos.R
\name{list_channel_videos}
\alias{list_channel_videos}
\title{Returns List of Requested Channel Videos}
\usage{
list_channel_videos(channel_id = NULL, max_results = 50, ...)
}
\arguments{
\item{channel_id}{String. ID of the channel. Required.}

\item{max_results}{Maximum number of items that should be returned. Integer. Optional. Can be between 0 and 50. Default is 50.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
character vector of video IDs
}
\description{
Returns List of Requested Channel Videos
}
\examples{

\dontrun{

# Set API token via yt_oauth() first

list_channel_videos(channel_id = "UCT5Cx1l4IS3wHkJXNyuj4TA")
list_channel_videos(channel_id = "UCT5Cx1l4IS3wHkJXNyuj4TA", max_results=10)
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/channels/list}
}

